 
/****** Object:  StoredProcedure [dbo].[P_EST_PRECIFICACAO_GRP_PRECO]    Script Date: 02/11/2014 08:46:04 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PRECIFICACAO_GRP_PRECO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PRECIFICACAO_GRP_PRECO]
GO
 
/****** Object:  StoredProcedure [dbo].[P_EST_PRECIFICACAO_GRP_PRECO]    Script Date: 02/11/2014 08:46:04 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

--EXEC P_EST_PRECIFICACAO_GRP_PRECO 1;
CREATE PROCEDURE [dbo].[P_EST_PRECIFICACAO_GRP_PRECO] (@CD_EMP INT, @APENAS_ENT_CD TINYINT=0)
AS
SET NOCOUNT ON;
-- Geracao das ultimas entradas por grupo de precificacao
--Versao 2796

	IF  OBJECT_ID('TEMPDB.DBO.#TMP_ENT') IS NOT NULL
	BEGIN
		 DROP TABLE #TMP_ENT
	END
 
	IF  OBJECT_ID('TEMPDB.DBO.#TMP_TBL_ENT') IS NOT NULL
	BEGIN
		 DROP TABLE #TMP_TBL_ENT
	END
	
	IF  OBJECT_ID('TEMPDB.DBO.#TMP_FIL_ENT') IS NOT NULL
	BEGIN
		 DROP TABLE #TMP_FIL_ENT
	END

	IF  OBJECT_ID('TEMPDB.DBO.#TBL_PROD_DPL') IS NOT NULL
	BEGIN
		 DROP TABLE #TBL_PROD_DPL
	END
	
	CREATE TABLE #TMP_FIL_ENT(CD_EMP TINYINT, CD_FILIAL INT)

	PRINT 'INSERT 1 '+CONVERT(VARCHAR, GETDATE(), 108);
	IF @APENAS_ENT_CD=0
	BEGIN
		INSERT INTO #TMP_FIL_ENT
		SELECT 
			CD_EMP,
			CD_FILIAL 
		FROM
			PRC_FILIAL
		WHERE
			CD_EMP=1
	END
	ELSE
	BEGIN
		INSERT INTO #TMP_FIL_ENT
		SELECT 
			1,
			CD_FILIAL  
		FROM
			 V_PRC_FILIAL_RELACAO_DEPOSITOS 
	END
	
	CREATE TABLE #TMP_ENT (CD_EMP INT, CD_PROD INT, CD_GRUPO INT,DT_ULT_ENT DATETIME )

	PRINT 'INSERT 2 '+CONVERT(VARCHAR, GETDATE(), 108);
 	INSERT INTO #TMP_ENT
	SELECT   
		I.CD_EMP,
		I.CD_PROD,
		G.CD_GRUPO,
		MAX(A.DT_ENT) DT_ULT_ENT 
	FROM 
		EST_NF_ENT A INNER JOIN EST_NF_ENT_IT I ON
		A.CD_EMP = I.CD_EMP AND
		A.CD_FILIAL = I.CD_FILIAL AND
		A.CD_NF = I.CD_NF 
		INNER JOIN GLB_MOV_OP ON
		A.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP 
		
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL G ON 
		A.CD_EMP = G.CD_EMP AND
		A.CD_FILIAL = G.CD_FILIAL
		
		INNER JOIN #TMP_FIL_ENT FL ON 
		G.CD_EMP = FL.CD_EMP AND
		G.CD_FILIAL = FL.CD_FILIAL
		
		LEFT JOIN PG_FORN F ON 
		A.CD_EMP = F.CD_EMP AND
		A.CD_FORN = F.CD_FORN 
	WHERE
		A.CD_EMP=@CD_EMP
		AND CASE WHEN GLB_MOV_OP.DEST_ORIG = 1  THEN 
				 ISNULL(F.PROC_PRECIFICACAO,0) ELSE 1 END = 1
		AND GLB_MOV_OP.TP_MOV_OP_TRANSA = 0
		AND GLB_MOV_OP.TP_MOV=0  
	GROUP BY   
		I.CD_EMP,
		G.CD_GRUPO, 
		I.CD_PROD;

	CREATE TABLE #TMP_TBL_ENT (CD_EMP INT, 
						   CD_FILIAL INT, 
						   CD_GRUPO INT,
						   CD_NF INT,
						   CD_PROD INT,
						   HR_ENT DATETIME,
						   LINHA INT)
	
	PRINT 'INSERT 3 '+CONVERT(VARCHAR, GETDATE(), 108);	 
	INSERT INTO #TMP_TBL_ENT
	SELECT 
		A.CD_EMP,
		A.CD_FILIAL,
		B.CD_GRUPO,
		A.CD_NF,
		I.CD_PROD,
		A.HR_ENT,
		ROW_NUMBER () OVER (ORDER BY A.HR_ENT DESC, A.CD_NF DESC, A.CD_FILIAL, A.CD_NF ) LINHA
	FROM 
		EST_NF_ENT A INNER JOIN EST_NF_ENT_IT I ON
		A.CD_EMP = I.CD_EMP AND
		A.CD_FILIAL = I.CD_FILIAL AND
		A.CD_NF = I.CD_NF 
		INNER JOIN GLB_MOV_OP ON
		A.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP 

		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL G ON 
		A.CD_EMP = G.CD_EMP AND
		A.CD_FILIAL = G.CD_FILIAL 
		INNER JOIN #TMP_FIL_ENT FL ON 
		G.CD_EMP = FL.CD_EMP AND
		G.CD_FILIAL = FL.CD_FILIAL
		
		INNER JOIN #TMP_ENT B ON
		G.CD_GRUPO = B.CD_GRUPO AND
		I.CD_PROD = B.CD_PROD AND 
		A.DT_ENT  = B.DT_ULT_ENT
		
		LEFT JOIN PG_FORN F ON 
		A.CD_EMP = F.CD_EMP AND
		A.CD_FORN = F.CD_FORN 
	WHERE
		A.CD_EMP=@CD_EMP
		AND CASE WHEN GLB_MOV_OP.DEST_ORIG = 1  THEN 
				 ISNULL(F.PROC_PRECIFICACAO,0) ELSE 1 END = 1
		AND GLB_MOV_OP.TP_MOV_OP_TRANSA = 0
		AND GLB_MOV_OP.TP_MOV=0;

	CREATE TABLE #TBL_PROD_DPL (CD_EMP INT, CD_PROD INT, CD_GRUPO INT, QTDE INT)
	
	PRINT 'INSERT 4 '+CONVERT(VARCHAR, GETDATE(), 108);  
	INSERT INTO #TBL_PROD_DPL
	SELECT 
		CD_EMP,
		CD_PROD,
		CD_GRUPO,
		COUNT(*) QTDE
	FROM 
		#TMP_TBL_ENT
	GROUP BY 
		CD_EMP,CD_GRUPO,CD_PROD
	HAVING COUNT(*)> 1
	
	PRINT 'INSERT 5 '+CONVERT(VARCHAR, GETDATE(), 108); 
	WHILE EXISTS (SELECT  A.CD_PROD, 
							A.CD_GRUPO,
							COUNT(*) QTDE
						FROM 
							#TBL_PROD_DPL A
							INNER JOIN #TMP_TBL_ENT B ON 
							A.CD_PROD = B.CD_PROD and
							A.CD_GRUPO = B.CD_GRUPO 
						GROUP BY 
							A.CD_GRUPO,A.CD_PROD
						HAVING COUNT(*)> 1)
		BEGIN
			 
			DELETE FROM E
			FROM 
				#TMP_TBL_ENT E
				INNER JOIN (SELECT  
								A.CD_PROD,
								A.CD_GRUPO,
								MAX(B.LINHA) LINHA,
								COUNT(*) QTDE
							FROM 
								#TBL_PROD_DPL A
								INNER JOIN #TMP_TBL_ENT B ON 
								A.CD_PROD = B.CD_PROD and
								A.CD_GRUPO = B.CD_GRUPO  
							GROUP BY 
								A.CD_GRUPO,A.CD_PROD
							HAVING COUNT(*)> 1) B ON 
				E.CD_GRUPO = B.CD_GRUPO AND			
				E.CD_PROD = B.CD_PROD AND
				E.LINHA   = B.LINHA
		
		END
		
		PRINT 'INSERT 6 '+CONVERT(VARCHAR, GETDATE(), 108);
		IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PRECIFICACAO_GRP_PRECO_EST_NF_ENT_IT_BKP]') AND type in (N'U'))
		BEGIN
			DROP TABLE [dbo].[EST_PRECIFICACAO_GRP_PRECO_EST_NF_ENT_IT_BKP]
		END 
		
		PRINT 'INSERT 7 '+CONVERT(VARCHAR, GETDATE(), 108);
		SELECT * 
			INTO EST_PRECIFICACAO_GRP_PRECO_EST_NF_ENT_IT_BKP  
		FROM 
			EST_PRECIFICACAO_GRP_PRECO_EST_NF_ENT_IT;
		
		PRINT 'INSERT 8 '+CONVERT(VARCHAR, GETDATE(), 108);  
		TRUNCATE TABLE EST_PRECIFICACAO_GRP_PRECO_EST_NF_ENT_IT;	

		PRINT 'INSERT 9 '+CONVERT(VARCHAR, GETDATE(), 108); 
		INSERT INTO EST_PRECIFICACAO_GRP_PRECO_EST_NF_ENT_IT (CD_EMP,CD_FILIAL,CD_NF,CD_PROD, CD_GRUPO,CD_ARV_MERC_FAMILIA)
		SELECT 
			E.CD_EMP,
			E.CD_FILIAL,
			E.CD_NF,
			E.CD_PROD,
			E.CD_GRUPO,
			M.CD_ARV_MERC_FAMILIA
		FROM 
			#TMP_TBL_ENT E 
			LEFT JOIN EST_PRECIFICACAO_GRP_PRECO_EST_NF_ENT_IT G ON 
			E.CD_EMP	= G.CD_EMP AND 
			E.CD_GRUPO	= G.CD_GRUPO AND 
			E.CD_PROD	= G.CD_PROD
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA M ON 
			E.CD_PROD = M.CD_PROD AND
			E.CD_EMP  = M.CD_EMP 
		WHERE
			G.CD_EMP IS NULL;
		
		PRINT 'INSERT 10 '+CONVERT(VARCHAR, GETDATE(), 108);	 
		--Atualizao do custo gerencial.. 
		UPDATE I
		SET		
			I.VLR_CUSTO_GER =  I.VLR_PRC_CUSTO - (ISNULL(i.VLR_DESC_FINAN,0)/i.QT_IT)
		FROM 
			EST_NF_ENT_IT I
			INNER JOIN EST_PRECIFICACAO_GRP_PRECO_EST_NF_ENT_IT G ON 
			I.CD_EMP	= G.CD_EMP AND
			I.CD_PROD	= G.CD_PROD AND
			I.CD_FILIAL = G.CD_FILIAL AND
			I.CD_NF		= G.CD_NF
		WHERE
			i.QT_IT> 0
			and I.VLR_CUSTO_GER <>  (I.VLR_PRC_CUSTO - (ISNULL(i.VLR_DESC_FINAN,0)/i.QT_IT)); 
			  
	IF  OBJECT_ID('TEMPDB.DBO.#TMP_ENT') IS NOT NULL
	BEGIN
		 DROP TABLE #TMP_ENT
	END
 
	IF  OBJECT_ID('TEMPDB.DBO.#TMP_TBL_ENT') IS NOT NULL
	BEGIN
		 DROP TABLE #TMP_TBL_ENT
	END
	
	IF  OBJECT_ID('TEMPDB.DBO.#TBL_PROD_DPL') IS NOT NULL
	BEGIN
		 DROP TABLE #TBL_PROD_DPL
	END
GO


